<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name')->default('100');
			$table->string('num', 10);
			$table->text('address');
			$table->string('postcode', 10);
			$table->string('city', 50);
			$table->string('country', 50);
			$table->decimal('lat', 10,6);
			$table->decimal('long', 10,6);
			$table->string('phone', 50);
			$table->date('from')->nullable();
			$table->date('to')->nullable();
			$table->enum('type', array('perso', 'family'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}