<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('auth_id')->unique();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->integer('year');
			$table->integer('campus_id')->unique();
			$table->enum('gender', array('m', 'f'));
			$table->string('mail', 100)->unique();
			$table->string('phone', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}