<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('gadz', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cursus', function(Blueprint $table) {
			$table->foreign('tbk_id')->references('id')->on('campus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_cursus', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_cursus', function(Blueprint $table) {
			$table->foreign('cursus_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('resams', function(Blueprint $table) {
			$table->foreign('tbk_id')->references('id')->on('campus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_social', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_social', function(Blueprint $table) {
			$table->foreign('social_id')->references('id')->on('socials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bouls', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('bouls', function(Blueprint $table) {
			$table->foreign('tbk_id')->references('id')->on('campus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tags', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('degrees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('degrees', function(Blueprint $table) {
			$table->foreign('cursus_id')->references('id')->on('cursus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('gadz', function(Blueprint $table) {
			$table->dropForeign('gadz_user_id_foreign');
		});
		Schema::table('cursus', function(Blueprint $table) {
			$table->dropForeign('cursus_tbk_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_user_id_foreign');
		});
		Schema::table('user_cursus', function(Blueprint $table) {
			$table->dropForeign('user_cursus_user_id_foreign');
		});
		Schema::table('user_cursus', function(Blueprint $table) {
			$table->dropForeign('user_cursus_cursus_id_foreign');
		});
		Schema::table('resams', function(Blueprint $table) {
			$table->dropForeign('resams_tbk_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('user_social', function(Blueprint $table) {
			$table->dropForeign('user_social_user_id_foreign');
		});
		Schema::table('user_social', function(Blueprint $table) {
			$table->dropForeign('user_social_social_id_foreign');
		});
		Schema::table('bouls', function(Blueprint $table) {
			$table->dropForeign('bouls_user_id_foreign');
		});
		Schema::table('bouls', function(Blueprint $table) {
			$table->dropForeign('bouls_tbk_id_foreign');
		});
		Schema::table('tags', function(Blueprint $table) {
			$table->dropForeign('tags_user_id_foreign');
		});
		Schema::table('degrees', function(Blueprint $table) {
			$table->dropForeign('degrees_user_id_foreign');
		});
		Schema::table('degrees', function(Blueprint $table) {
			$table->dropForeign('degrees_cursus_id_foreign');
		});
	}
}