<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 50);
			$table->string('middle_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('suffix', 10)->nullable();
			$table->string('preferred_name', 50)->nullable();
			$table->string('email', 50)->nullable();
			$table->integer('designation_id')->unsigned()->nullable();
			$table->longText('profile_picture')->nullable();
			$table->string('mobile', 15)->nullable();
			$table->string('ssn', 20);
			$table->timestamp('dob')->nullable();
			$table->boolean('status')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}