<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamStaffMembersTable extends Migration {

	public function up()
	{
		Schema::create('team_staff_members', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('supervisor_id')->unsigned();
			$table->integer('team_name_id')->unsigned();
			$table->string('team_title', 50);
			$table->float('payment', 8,2)->default('0');
			$table->integer('wage_rate_id')->unsigned();
			$table->integer('commission_id')->unsigned()->nullable();
			$table->json('associated_company_ids')->nullable();
			$table->json('associated_store_id')->nullable();
			$table->boolean('status')->default(0);
			$table->timestamp('start_date');
			$table->timestamp('end_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('team_staff_members');
	}
}