<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Address extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'home', 'mailing', 'fathers_house');
	protected $visible = array('user_id', 'home', 'mailing', 'fathers_house');

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

}