<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmergencyContact extends Eloquent {

	protected $table = 'emegency_contacts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'relation', 'name', 'mobile', 'email', 'fax');
	protected $visible = array('user_id', 'relation', 'name', 'mobile', 'email', 'fax');

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

}