<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TeamStaffMember extends Eloquent {

	protected $table = 'team_staff_members';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('supervisor_id', 'team_name_id', 'team_title', 'payment', 'wage_rate_id', 'commission_id', 'associated_company_ids', 'associated_store_id', 'status', 'start_date', 'end_date');
	protected $visible = array('supervisor_id', 'team_name_id', 'team_title', 'payment', 'wage_rate_id', 'commission_id', 'associated_company_ids', 'associated_store_id', 'status', 'start_date', 'end_date');

	public function teamname()
	{
		return $this->hasOne('App\Models\Tenants\TeamName', 'team_name_id');
	}

	public function wagerate()
	{
		return $this->hasOne('App\Models\Tenants\WageRate', 'wage_rate_id');
	}

	public function supervisor()
	{
		return $this->hasOne('App\User', 'supervisor_id');
	}

	public function commission()
	{
		return $this->hasOne('App\Models\Tenants\Commission', 'commission_id');
	}

}