<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categorie', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_prix', function(Blueprint $table) {
			$table->foreign('NIdProduit')->references('NIdProduit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_prix', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_solde_prix', function(Blueprint $table) {
			$table->foreign('NIdProduit')->references('NIdProduit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_solde_prix', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('NIdProduit')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_quantiter', function(Blueprint $table) {
			$table->foreign('NIdProduit')->references('NIdProduit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_quantiter', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produit_note', function(Blueprint $table) {
			$table->foreign('NIdProduit')->references('NIdProduit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commande', function(Blueprint $table) {
			$table->foreign('NIdUsers')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commande_details', function(Blueprint $table) {
			$table->foreign('NIdCommande')->references('NIdCommande')->on('commande')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commande_details', function(Blueprint $table) {
			$table->foreign('NIdProduit')->references('NIdProduit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_NIdUsers_foreign');
		});
		Schema::table('categorie', function(Blueprint $table) {
			$table->dropForeign('categorie_NIdUsers_foreign');
		});
		Schema::table('produit_prix', function(Blueprint $table) {
			$table->dropForeign('produit_prix_NIdProduit_foreign');
		});
		Schema::table('produit_prix', function(Blueprint $table) {
			$table->dropForeign('produit_prix_NIdUsers_foreign');
		});
		Schema::table('produit_solde_prix', function(Blueprint $table) {
			$table->dropForeign('produit_solde_prix_NIdProduit_foreign');
		});
		Schema::table('produit_solde_prix', function(Blueprint $table) {
			$table->dropForeign('produit_solde_prix_NIdUsers_foreign');
		});
		Schema::table('produit_quantiter', function(Blueprint $table) {
			$table->dropForeign('produit_quantiter_NIdProduit_foreign');
		});
		Schema::table('produit_quantiter', function(Blueprint $table) {
			$table->dropForeign('produit_quantiter_NIdUsers_foreign');
		});
		Schema::table('produit_note', function(Blueprint $table) {
			$table->dropForeign('produit_note_NIdProduit_foreign');
		});
		Schema::table('commande', function(Blueprint $table) {
			$table->dropForeign('commande_NIdUsers_foreign');
		});
		Schema::table('commande_details', function(Blueprint $table) {
			$table->dropForeign('commande_details_NIdCommande_foreign');
		});
		Schema::table('commande_details', function(Blueprint $table) {
			$table->dropForeign('commande_details_NIdProduit_foreign');
		});
	}
}