<?php

namespace Produit;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Produit extends Eloquent {

	protected $table = 'produits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function produitPrix()
	{
		return $this->hasMany('ProduitPrix');
	}

	public function produitSoldePrix()
	{
		return $this->hasMany('ProduitSoldePrix');
	}

	public function produitQuantiter()
	{
		return $this->hasMany('ProduitQuantiter');
	}

	public function produitNote()
	{
		return $this->hasMany('ProduitNote');
	}

	public function produitCommandeDetails()
	{
		return $this->hasMany('CommandeDetails');
	}

}