<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191)->nullable();
			$table->string('email', 191)->nullable();
			$table->integer('country_id')->unsigned();
			$table->string('reason', 191)->nullable();
			$table->text('body')->nullable();
			$table->enum('read', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}