<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDisabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('disabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191)->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('disabilities');
	}
}