<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobArticlesTable extends Migration {

	public function up()
	{
		Schema::create('job_articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->string('image', 191)->nullable();
			$table->text('body')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('job_articles');
	}
}