<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResumesTable extends Migration {

	public function up()
	{
		Schema::create('resumes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('fullname', 191)->nullable();
			$table->integer('disability_id')->unsigned();
			$table->enum('social_status', array('single', 'separated', 'divorced', 'widower', 'married'))->nullable();
			$table->string('social_insurance', 191)->nullable();
			$table->string('email', 191)->nullable();
			$table->string('city', 191)->nullable();
			$table->string('mobile', 191)->nullable();
			$table->date('birthday')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('nationality', 191)->nullable();
			$table->string('image', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('resumes');
	}
}