<?php

namespace Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'status', 'parent_id');

	public function jobs()
	{
		return $this->hasMany('Job', 'category_id');
	}

	public function parent()
	{
		return $this->belongsTo('Category', 'parent_id');
	}

	public function sub_categories()
	{
		return $this->belongsTo('Category', 'parent_id');
	}

	public function experiences()
	{
		return $this->hasMany('UserExpericence', 'company_field_id');
	}

	public function prefered_jobs()
	{
		return $this->hasMany('PreferedJob', 'job_category_id');
	}

}