<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'parent_id', 'type');

	public function users()
	{
		return $this->hasMany('\User', 'city_id');
	}

	public function user_nationalities()
	{
		return $this->hasMany('\User', 'nationality_id');
	}

	public function jobs()
	{
		return $this->hasMany('Job', 'city_id');
	}

	public function settledown_country_jobs()
	{
		return $this->hasMany('Job', 'settledown_country_id');
	}

	public function nationalities_jobs()
	{
		return $this->hasMany('Job', 'nationality_id');
	}

	public function experiences()
	{
		return $this->hasMany('UserExpericence', 'city_id');
	}

	public function parent()
	{
		return $this->belongsTo('City', 'parent_id');
	}

	public function cities()
	{
		return $this->hasMany('City', 'parent_id');
	}

	public function contacts()
	{
		return $this->hasMany('Contact', 'country_id');
	}

}