<?php

namespace Models;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;
	protected $fillable = array('user_id', 'hiring_responsible', 'phone_responsible', 'mobile_responsible', 'transfers_responsible', 'establishment_data', 'company_field', 'details');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function jobs()
	{
		return $this->hasMany('Job', 'company_id');
	}

}