<?php

namespace Models;

class Disability extends Eloquent {

	protected $table = 'disabilities';
	public $timestamps = true;
	protected $fillable = array('name', 'status');

	public function users()
	{
		return $this->hasMany('\User', 'disability_id');
	}

	public function jobs()
	{
		return $this->hasMany('Job', 'disability_id');
	}

	public function resumes()
	{
		return $this->hasMany('Resume', 'disability_id');
	}

}