<?php

namespace Models;

class Job extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;
	protected $fillable = array('title', 'body', 'skills', 'end_date', 'category_id', 'disability_id', 'job_start_date', 'job_system', 'salary', 'salary_currency', 'transfer_salary', 'transfer_salary_currency', 'health_allowance', 'health_write', 'empty_jobs', 'region', 'city_id', 'company_id', 'prefer_exp', 'exp_years', 'settledown_country_id', 'gender', 'nationality_id', 'education_id', 'status', 'admin_opinion');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function disability()
	{
		return $this->belongsTo('Disability', 'disability_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function settledown_country()
	{
		return $this->belongsTo('City', 'settledown_country_id');
	}

	public function nationality()
	{
		return $this->hasMany('City', 'nationality_id');
	}

	public function education()
	{
		return $this->belongsTo('Education', 'education_id');
	}

	public function favourite_users()
	{
		return $this->belongsToMany('User', 'favourites', 'job_id', 'user_id');
	}

	public function applied_users()
	{
		return $this->belongsToMany('User', 'applied_jobs', 'job_id', 'user_id');
	}

}