<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobHistory extends Eloquent {

	protected $table = 'job_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'hired', 'company_name', 'story');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}