<?php

namespace Models;

class PreferedJob extends Eloquent {

	protected $table = 'prefered_jobs';
	public $timestamps = true;
	protected $fillable = array('user_id', 'countries', 'job_title', 'job_category_id', 'job_system', 'salary', 'salary_currency');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'job_category_id');
	}

}