<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subscription extends Eloquent {

	protected $table = 'subscriptions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'ad_numbers', 'cv_count', 'price', 'website_interview');

	public function current_subscription()
	{
		return $this->hasMany('\User', 'current_subscription_id');
	}

	public function company_subscriptions()
	{
		return $this->belongsToMany('User', 'company_subscription', 'subscription_id', 'company_id');
	}

}