<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Disability extends Model 
{

    protected $table = 'disabilities';
    public $timestamps = true;
    protected $fillable = array('name', 'status');

    public function users()
    {
        return $this->hasMany('\User', 'disability_id');
    }

    public function jobs()
    {
        return $this->hasMany('Job', 'disability_id');
    }

    public function resumes()
    {
        return $this->hasMany('Resume', 'disability_id');
    }

}