<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Resume extends Model 
{

    protected $table = 'resumes';
    public $timestamps = true;
    protected $fillable = array('user_id', 'fullname', 'disability_id', 'social_status', 'social_insurance', 'email', 'city', 'mobile', 'birthday', 'gender', 'nationality', 'image');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function disability()
    {
        return $this->belongsTo('Disability', 'disability_id');
    }

    public function courses()
    {
        return $this->hasMany('ResumeCourses', 'resume_id');
    }

    public function skills()
    {
        return $this->hasMany('ResumeSkill', 'resume_id');
    }

    public function qualifications()
    {
        return $this->hasMany('ResumeQualification', 'resume_id');
    }

    public function experiences()
    {
        return $this->hasMany('ResumeExperience', 'resume_id');
    }

}