<?php

namespace Batch_Checked_Out;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Batch_Checked_Out extends Model 
{

    protected $table = 'batch_checked_out';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function checked_out_demands()
    {
        return $this->hasMany('Checked_Out_Demands', 'batch_tracking_number', 'fk_batch_tracking_number');
    }

}