<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('title')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('auction_id')->unsigned();
			$table->enum('type', array('admin', 'auction'))->nullable();
			$table->string('id_firebase')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}