<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('languages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code');
			$table->boolean('is_rtl')->default(false);
			$table->boolean('is_default')->default(false);
			$table->boolean('is_active')->default(false);
			$table->string('name')->unique();
		});
	}

	public function down()
	{
		Schema::drop('languages');
	}
}