<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizzesTable extends Migration {

	public function up()
	{
		Schema::create('quizzes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->boolean('status')->default(true);
			$table->bigInteger('category_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quizzes');
	}
}