<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->string('price');
			$table->boolean('is_free')->default(false);
			$table->text('about');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}