<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('quizzes', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quizze_answers', function(Blueprint $table) {
			$table->foreign('quizze_id')->references('id')->on('quizzes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('consultation_id')->references('id')->on('consultations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment_cards', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_language_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_sub_category_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_course_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_section_id_foreign');
		});
		Schema::table('quizzes', function(Blueprint $table) {
			$table->dropForeign('quizzes_category_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_course_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_user_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_lesson_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_user_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_course_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_course_id_foreign');
		});
		Schema::table('quizze_answers', function(Blueprint $table) {
			$table->dropForeign('quizze_answers_quizze_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_course_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_user_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_course_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_consultation_id_foreign');
		});
		Schema::table('payment_cards', function(Blueprint $table) {
			$table->dropForeign('payment_cards_user_id_foreign');
		});
	}
}