<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoFormPropertyInformationTable extends Migration {

	public function up()
	{
		Schema::create('hmo_form_property_information', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hmo_form_id')->unsigned();
			$table->integer('occupancy_type');
			$table->string('property_age')->nullable();
			$table->integer('bedrooms')->nullable();
			$table->integer('living_rooms')->nullable();
			$table->integer('bathrooms')->nullable();
			$table->integer('sinks')->nullable();
			$table->integer('hand_basins')->nullable();
			$table->integer('kitchens')->nullable();
			$table->integer('shower_rooms')->nullable();
			$table->integer('toilets')->nullable();
			$table->integer('self_contained_flats')->nullable();
			$table->integer('non_self_contained_flats')->nullable();
			$table->integer('households');
			$table->integer('total_persons');
			$table->integer('total_households')->nullable();
			$table->integer('max_persons_applied_for');
			$table->integer('max_households_applied_for');
			$table->boolean('resident_landlord')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_form_property_information');
	}
}