<?php

namespace App\Models;

class HmoFormPropertyOwnership extends Eloquent {

	protected $table = 'hmo_form_property_ownership';
	public $timestamps = true;
	protected $fillable = array('hmo_form_id', 'property_ownership_type_id', 'name', 'email', 'telephone', 'company_name', 'job_position', 'interest_in_property');

	public function ownershipType()
	{
		return $this->belongsTo('PropertyOwnershipType', 'property_ownership_type_id', 'id');
	}

	public function hmoForm()
	{
		return $this->belongsTo('HmoForm', 'hmo_form_id');
	}

	public function address()
	{
		return $this->morphOne('Address', 'addressable');
	}

}