<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned()->nullable();
			$table->string('image', 150);
			$table->string('name', 150);
			$table->string('phone', 150);
			$table->string('country_code', 10);
			$table->string('email', 150);
			$table->string('lat', 50);
			$table->string('lng', 50);
			$table->text('map_desc');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}