<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('country_code');
			$table->string('phone');
			$table->string('lat');
			$table->string('lng');
			$table->string('map_desc');
			$table->string('commerical_image');
			$table->string('password');
			$table->string('image', 255)->default('default.png');
			$table->string('email', 255);
			$table->string('file', 150);
			$table->string('logo', 100);
			$table->double('wallet', 0,0);
			$table->integer('city_id')->unsigned()->nullable();
			$table->boolean('is_approved')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}