<?php

class Groups extends Eloquent {

	protected $table = 'Group';
	public $timestamps = false;

	public function class()
	{
		return $this->belongsTo('Class');
	}

	public function tasks()
	{
		return $this->hasMany('Tasks');
	}

	public function events()
	{
		return $this->hasMany('Events');
	}

	public function students()
	{
		return $this->hasMany('Students');
	}

	public function lessons()
	{
		return $this->hasMany('\Lessons');
	}

	public function notifications()
	{
		return $this->morphMany('Notifications');
	}

	public function announces()
	{
		return $this->morphMany('Announces');
	}

}