<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->text('description')->nullable();
			$table->string('location')->nullable();
			$table->integer('responsable_id')->unsigned();
			$table->integer('captain_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}