<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRidesListTable extends Migration {

	public function up()
	{
		Schema::create('ridesList', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('status', array('active', 'deleted', 'done'));
			$table->datetime('fromDate');
			$table->datetime('endDate');
			$table->timestamps();
			$table->string('Identifier', 10);
			$table->integer('driverId');
			$table->integer('truckId');
			$table->integer('trailerId');
			$table->json('locationsList');
			$table->integer('Revenue');
			$table->integer('Distance');
			$table->integer('driverPrice');
			$table->mediumText('driverComment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ridesList');
	}
}