<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->decimal('discount', 14,2)->nullable();
			$table->decimal('subtotal', 14,2)->nullable();
			$table->decimal('total', 14,2)->nullable();
			$table->string('invoice_date', 21)->nullable();
			$table->string('delivery_date', 21)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}