<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('logo', 255)->nullable();
			$table->text('title');
			$table->string('hero_image', 255)->nullable();
			$table->text('description');
			$table->string('email', 255);
			$table->string('phone', 255)->nullable();
			$table->string('github_link')->nullable();
			$table->string('facebook_link')->nullable();
			$table->string('linkedin_link', 255)->nullable();
			$table->string('cv_file', 255);
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}