<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email')->unique();
			$table->string('country_code');
			$table->string('phone');
			$table->string('password');
			$table->enum('type', array('employee', 'search_employee'));
			$table->string('country_id');
			$table->integer('nationality_id');
			$table->integer('current_country_id')->nullable();
			$table->integer('education_level')->nullable();
			$table->date('d_o_b');
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('cv')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}