<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'country_code', 'phone', 'password', 'type', 'country_id', 'nationality_id', 'current_country_id', 'education_level', 'd_o_b', 'gender', 'cv');
	protected $hidden = array('password');

	public function countries()
	{
		return $this->hasMany('App\Models\Country');
	}

	public function nationalities()
	{
		return $this->hasMany('App\Models\Nationality');
	}

	public function current_country_id()
	{
		return $this->hasMany('App\Models\Country');
	}

	public function AdsUser()
	{
		return $this->belongsToMany('App\Models\AdsUser');
	}

}