<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->string('country_key')->nullable();
			$table->enum('type', array('person', 'company'))->nullable();
			$table->string('image')->nullable();
			$table->integer('city_id')->unsigned();
			$table->longText('lat')->nullable();
			$table->longText('lng')->nullable();
			$table->longText('address')->nullable();
			$table->string('email')->nullable();
			$table->string('Bank_name')->nullable();
			$table->string('account_number')->nullable();
			$table->longText('Iban_number')->nullable();
			$table->integer('category_id')->unsigned();
			$table->decimal('meter_price')->nullable()->default('0');
			$table->decimal('consultant_price')->nullable();
			$table->string('identity_image')->nullable();
			$table->boolean('have_tools')->nullable()->default(0);
			$table->string('code')->nullable();
			$table->boolean('is_active')->nullable()->default(0);
			$table->decimal('rate')->nullable()->default('0');
			$table->boolean('is_online')->nullable()->default(1);
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}