<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('priority', 'name_en', 'name_ar', 'details_en', 'details_ar', 'start_at', 'expire_at', 'price', 'clinic_id', 'specialty_id', 'city_id', 'longitude', 'latitude', 'clicks', 'uses');

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function clinic()
	{
		return $this->belongsTo('Clinic', 'clinic_id');
	}

	public function specialty()
	{
		return $this->belongsTo('Specialty', 'specialty_id');
	}

}