<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostReaction extends Model 
{

    protected $table = 'post_reaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'reaction_id', 'created_by');

    public function reaction()
    {
        return $this->belongsTo('Reaction', 'reaction_id');
    }

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function client()
    {
        return $this->belongsTo('User', 'created_by');
    }

}