<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdTag extends Model 
{

    protected $table = 'ad_tag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ad_id', 'tag_id');

    public function ad()
    {
        return $this->hasOne('Ad', 'ad_id');
    }

    public function tag()
    {
        return $this->belongsTo('Tag', 'tag_id');
    }

}