<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('locataire', function(Blueprint $table) {
			$table->foreign('id_proprietaire')->references('id_proprietaire')->on('proprietaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propriete', function(Blueprint $table) {
			$table->foreign('id_proprietaire')->references('id_proprietaire')->on('proprietaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propriete', function(Blueprint $table) {
			$table->foreign('id_type_propriete')->references('id')->on('type_propriete')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('finance', function(Blueprint $table) {
			$table->foreign('id_propriete')->references('id_propriete')->on('propriete')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('finance', function(Blueprint $table) {
			$table->foreign('id_paiement')->references('id_paiement')->on('paiement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->foreign('location')->references('id_location')->on('location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->foreign('frequence')->references('id')->on('frequence')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->foreign('moyen')->references('id')->on('moyen')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('id_admin')->references('id_admin')->on('administrateur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('id_proprietaire')->references('id_proprietaire')->on('proprietaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('id_locataire')->references('id_locataire')->on('locataire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('location', function(Blueprint $table) {
			$table->foreign('id_propriete')->references('id_propriete')->on('propriete')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('abonnement', function(Blueprint $table) {
			$table->foreign('type')->references('id')->on('type_abonnement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrat', function(Blueprint $table) {
			$table->foreign('locataire')->references('id_locataire')->on('locataire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('locataire', function(Blueprint $table) {
			$table->dropForeign('locataire_id_proprietaire_foreign');
		});
		Schema::table('propriete', function(Blueprint $table) {
			$table->dropForeign('propriete_id_proprietaire_foreign');
		});
		Schema::table('propriete', function(Blueprint $table) {
			$table->dropForeign('propriete_id_type_propriete_foreign');
		});
		Schema::table('finance', function(Blueprint $table) {
			$table->dropForeign('finance_id_propriete_foreign');
		});
		Schema::table('finance', function(Blueprint $table) {
			$table->dropForeign('finance_id_paiement_foreign');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->dropForeign('paiement_location_foreign');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->dropForeign('paiement_frequence_foreign');
		});
		Schema::table('paiement', function(Blueprint $table) {
			$table->dropForeign('paiement_moyen_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_id_admin_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_id_proprietaire_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_id_locataire_foreign');
		});
		Schema::table('location', function(Blueprint $table) {
			$table->dropForeign('location_id_propriete_foreign');
		});
		Schema::table('abonnement', function(Blueprint $table) {
			$table->dropForeign('abonnement_type_foreign');
		});
		Schema::table('contrat', function(Blueprint $table) {
			$table->dropForeign('contrat_locataire_foreign');
		});
	}
}