<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookCopiesTable extends Migration {

	public function up()
	{
		Schema::create('book_copies', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('book_id');
			$table->string('isbn');
			$table->integer('author_id')->unsigned();
			$table->integer('pub_house_id')->unsigned();
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('book_copies');
	}
}