<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlumnosTable extends Migration {

	public function up()
	{
		Schema::create('alumnos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('numctrl', 20);
			$table->string('curp', 20);
			$table->string('nombres', 80);
			$table->string('paterno', 80);
			$table->string('materno', 80);
			$table->date('fecha_nacimiento');
			$table->integer('id_estado');
			$table->integer('id_municipio')->unsigned();
			$table->integer('id_localidad')->unsigned();
			$table->string('colonia', 255);
			$table->string('domicilio', 255);
			$table->string('numero', 5);
			$table->string('cp', 6);
			$table->string('telefono', 15);
			$table->string('email', 120);
			$table->timestamps();
			$table->integer('id_status');
		});
	}

	public function down()
	{
		Schema::drop('alumnos');
	}
}