<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tblUserTypeDetail', function(Blueprint $table) {
			$table->foreign('idUser')->references('idUser')->on('tblUser')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUserTypeDetail', function(Blueprint $table) {
			$table->foreign('idUserType')->references('idUserType')->on('tblUserTypeDetail')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUserBaseAirport', function(Blueprint $table) {
			$table->foreign('idUser')->references('idUser')->on('tblUser')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUserBaseAirport', function(Blueprint $table) {
			$table->foreign('idBaseAirport')->references('idBaseAirport')->on('tblBaseAirport')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->foreign('idAircraftType')->references('idAircraftType')->on('tblAircraftType')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->foreign('idAircraftMake')->references('idAircraftMake')->on('tblAircraftMake')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->foreign('idAircraftModel')->references('idAircraftModel')->on('tblAircraftModel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUserAircraft', function(Blueprint $table) {
			$table->foreign('idUser')->references('idUser')->on('tblUser')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUserAircraft', function(Blueprint $table) {
			$table->foreign('idAircraft')->references('idAircraft')->on('tblAircraft')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tblUserTypeDetail', function(Blueprint $table) {
			$table->dropForeign('tblUserTypeDetail_idUser_foreign');
		});
		Schema::table('tblUserTypeDetail', function(Blueprint $table) {
			$table->dropForeign('tblUserTypeDetail_idUserType_foreign');
		});
		Schema::table('tblUserBaseAirport', function(Blueprint $table) {
			$table->dropForeign('tblUserBaseAirport_idUser_foreign');
		});
		Schema::table('tblUserBaseAirport', function(Blueprint $table) {
			$table->dropForeign('tblUserBaseAirport_idBaseAirport_foreign');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->dropForeign('tblAircraft_idAircraftType_foreign');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->dropForeign('tblAircraft_idAircraftMake_foreign');
		});
		Schema::table('tblAircraft', function(Blueprint $table) {
			$table->dropForeign('tblAircraft_idAircraftModel_foreign');
		});
		Schema::table('tblUserAircraft', function(Blueprint $table) {
			$table->dropForeign('tblUserAircraft_idUser_foreign');
		});
		Schema::table('tblUserAircraft', function(Blueprint $table) {
			$table->dropForeign('tblUserAircraft_idAircraft_foreign');
		});
	}
}