<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('full_name', 'username', 'slug', 'email', 'birthday', 'password', 'avatar_url', 'remember_token', 'active', 'activation_code', 'deleted_at', 'current_team_id', 'last_accessed_at');
    protected $visible = array('full_name', 'username', 'slug', 'email', 'birthday', 'avatar_url', 'active', 'deleted_at', 'current_team_id', 'last_accessed_at');
    protected $hidden = array('password', 'remember_token', 'activation_code');

    public function teams()
    {
        return $this->belongsToMany('Team');
    }

    public function invitations()
    {
        return $this->hasMany('Invitation');
    }

}